# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 8
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR8_strategy.txt
# LLM Suggested Fallback: C

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Initial Phase: Cooperate in first 3 rounds
    if current_round <= 3:
        return "C"
    
    # Check for unconditional strategies in opponent's code
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D" if current_round > 1 else "C"
    if is_always_d:
        return "C"
    
    # Mid-Game: Analyze opponent's history
    if 4 <= current_round <= 7:
        if all(move == "C" for move in opp_history):
            return "C"
        elif "D" in opp_history:
            if random.random() < 0.2:  # 20% chance to forgive
                return "C"
            else:
                return opp_history[-1]  # TFT
    
    # End-Game: Adjust based on opponent's cooperation rate
    if current_round >= 8:
        coop_rate = sum(1 for move in opp_history if move == "C") / len(opp_history)
        if coop_rate > 0.7:
            return "C"
        else:
            return "D"
    
    # Default fallback
    return "C"